package gov.va.vinci.dart.json.builder;

import java.util.ArrayList;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.json.LocationListView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestLocationListViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		LocationListViewBuilder builder = new LocationListViewBuilder();
		
		try {
			builder.build((List<Location>)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		List<Location> locationList = new ArrayList<Location>();
		
		LocationListView llv = builder.build(locationList);
		Assert.assertNotNull(llv);
		Assert.assertNotNull(llv.getLocations());
		Assert.assertEquals(llv.getLocations().size(), 0);
		
		Location location = DartObjectFactory.getInstance().getLocationDAO().findById(1);
		
		locationList.add(location);
		
		llv = builder.build(locationList);
		Assert.assertNotNull(llv);
		Assert.assertNotNull(llv.getLocations());
		Assert.assertEquals(llv.getLocations().size(), 1);
		
		String lv = llv.getLocations().get(0);
		Assert.assertNotNull(lv);
		Assert.assertEquals(lv, location.getName());
	}
	
}
